/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.ElementListUnion;
import com.aliyun.odps.simpleframework.xml.Path;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.task.AdminTask;
import com.aliyun.odps.task.AlgoTask;
import com.aliyun.odps.task.BackupTask;
import com.aliyun.odps.task.BigGraphTask;
import com.aliyun.odps.task.CacheTask;
import com.aliyun.odps.task.CopyTask;
import com.aliyun.odps.task.CupidTask;
import com.aliyun.odps.task.DTTask;
import com.aliyun.odps.task.DebugTask;
import com.aliyun.odps.task.GalaxyTask;
import com.aliyun.odps.task.GraphTask;
import com.aliyun.odps.task.LOTTask;
import com.aliyun.odps.task.LineageTask;
import com.aliyun.odps.task.MapReduceTask;
import com.aliyun.odps.task.MatrixTask;
import com.aliyun.odps.task.MergeTask;
import com.aliyun.odps.task.MoyeTask;
import com.aliyun.odps.task.PLTask;
import com.aliyun.odps.task.PSTask;
import com.aliyun.odps.task.SQLCostTask;
import com.aliyun.odps.task.SQLRTTask;
import com.aliyun.odps.task.SQLSuggestTask;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.task.ServerTask;
import com.aliyun.odps.task.SqlPlanTask;
import com.aliyun.odps.task.StatTask;
import com.aliyun.odps.task.XLibTask;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class Job {
    JobModel model;

    public Job() {
        this.model = new JobModel();
    }

    public Job(JobModel model) {
        this.model = model;
    }

    public String getName() {
        return this.model.name;
    }

    public void setName(String name) {
        this.model.name = name;
    }

    public String getComment() {
        return this.model.comment;
    }

    public void setComment(String comment) {
        this.model.comment = comment;
    }

    public String getOwner() {
        return this.model.owner;
    }

    public int getPriority() {
        return this.model.priority;
    }

    public void setPriority(int priority) {
        this.model.priority = priority;
    }

    public Date getCreatedTime() {
        return this.model.creationTime;
    }

    public Date getLastModifiedTime() {
        return this.model.lastModified;
    }

    public List<Task> getTasks() {
        return this.model.tasks;
    }

    public void addTask(Task task) {
        this.model.tasks.add(task);
    }

    public String getRunningCluster() {
        return this.model.runningCluster;
    }

    public void setRunningCluster(String runningCluster) {
        this.model.runningCluster = runningCluster;
    }

    public String toXmlString() throws OdpsException {
        try {
            return SimpleXmlUtils.marshal(this.model);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    @Root(name="Job", strict=false)
    static class JobModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date creationTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModified;
        @Element(name="Priority", required=false)
        int priority = 9;
        @Element(name="RunningCluster", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String runningCluster;
        @Path(value="Tasks")
        @ElementListUnion(value={@ElementList(entry="Graph", inline=true, type=GraphTask.class), @ElementList(entry="LOT", inline=true, type=LOTTask.class), @ElementList(entry="SQLPlan", inline=true, type=SqlPlanTask.class), @ElementList(entry="SQL", inline=true, type=SQLTask.class), @ElementList(entry="SQLRT", inline=true, type=SQLRTTask.class), @ElementList(entry="XLib", inline=true, type=XLibTask.class), @ElementList(entry="SQLCost", inline=true, type=SQLCostTask.class), @ElementList(entry="MOYE", inline=true, type=MoyeTask.class), @ElementList(entry="Galaxy", inline=true, type=GalaxyTask.class), @ElementList(entry="CUPID", inline=true, type=CupidTask.class), @ElementList(entry="Merge", inline=true, type=MergeTask.class), @ElementList(entry="AlgoTask", inline=true, type=AlgoTask.class), @ElementList(entry="Backup", inline=true, type=BackupTask.class), @ElementList(entry="DT", inline=true, type=DTTask.class), @ElementList(entry="Lineage", inline=true, type=LineageTask.class), @ElementList(entry="MapReduce", inline=true, type=MapReduceTask.class), @ElementList(entry="PLSQL", inline=true, type=PLTask.class), @ElementList(entry="Matrix", inline=true, type=MatrixTask.class), @ElementList(entry="Stat", inline=true, type=StatTask.class), @ElementList(entry="Admin", inline=true, type=AdminTask.class), @ElementList(entry="PS", inline=true, type=PSTask.class), @ElementList(entry="COPY", inline=true, type=CopyTask.class), @ElementList(entry="Cache", inline=true, type=CacheTask.class), @ElementList(entry="Server", inline=true, type=ServerTask.class), @ElementList(entry="BIGGRAPH", inline=true, type=BigGraphTask.class), @ElementList(entry="DebugTask", inline=true, type=DebugTask.class), @ElementList(entry="SQLSuggest", inline=true, type=SQLSuggestTask.class)})
        List<Task> tasks = new LinkedList<Task>();

        JobModel() {
        }
    }
}

