/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.simpleframework.xml.convert.Converter;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Project
extends LazyLoad {
    private ProjectModel model;
    private RestClient client;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private Map<String, String> allProperties;
    private SecurityManager securityManager = null;
    private Clusters clusters;
    private boolean usedByGroupApi = false;

    Project(ProjectModel model, RestClient client) {
        this.model = model;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildProjectResource(this.model.name);
        HashMap<String, String> params = null;
        if (this.usedByGroupApi) {
            params = new HashMap<String, String>();
            params.put("isGroupApi", "true");
        }
        Response resp = this.client.request(resource, "GET", params, null, null);
        try {
            this.model = SimpleXmlUtils.unmarshal(resp, ProjectModel.class);
            Map<String, String> headers = resp.getHeaders();
            this.model.owner = headers.get("x-odps-owner");
            this.model.creationTime = DateUtils.parseRfc822Date(headers.get("x-odps-creation-time"));
            this.model.lastModified = DateUtils.parseRfc822Date(headers.get("Last-Modified"));
            this.properties = this.model.properties;
            this.clusters = this.model.clusters;
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + ProjectModel.class, e);
        }
        this.setLoaded(true);
    }

    public String getName() {
        return this.model.name;
    }

    public ProjectType getType() throws OdpsException {
        if (this.model.type == null) {
            this.lazyLoad();
        }
        if (this.model.type != null) {
            try {
                return ProjectType.valueOf(this.model.type.toLowerCase());
            }
            catch (Exception e) {
                throw new OdpsException("Unknown project type: " + this.model.type);
            }
        }
        return ProjectType.managed;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    void setComment(String comment) {
        this.model.comment = comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.creationTime == null) {
            this.lazyLoad();
        }
        return this.model.creationTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModified == null) {
            this.lazyLoad();
        }
        return this.model.lastModified;
    }

    String getProjectGroupName() {
        this.lazyLoad();
        return this.model.projectGroupName;
    }

    public Status getStatus() {
        if (this.model.state == null) {
            this.lazyLoad();
        }
        Status status = null;
        try {
            status = Status.valueOf(this.model.state.toUpperCase());
        }
        catch (Exception e) {
            return Status.UNKOWN;
        }
        return status;
    }

    public Map<String, String> getProperties() {
        this.lazyLoad();
        return this.properties;
    }

    public Map<String, String> getAllProperties() throws OdpsException {
        if (this.allProperties == null) {
            String resource = ResourceBuilder.buildProjectResource(this.model.name);
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("properties", "all");
            Response resp = this.client.request(resource, "GET", params, null, null);
            try {
                ProjectModel model = SimpleXmlUtils.unmarshal(resp, ProjectModel.class);
                this.allProperties = model.properties;
            }
            catch (Exception e) {
                throw new OdpsException("Can't bind xml to " + ProjectModel.class, e);
            }
        }
        return this.allProperties;
    }

    public String getProperty(String key) {
        this.lazyLoad();
        return this.properties == null ? null : this.properties.get(key);
    }

    String getDefaultCluster() {
        this.usedByGroupApi = true;
        this.lazyLoad();
        return this.model.defaultCluster;
    }

    List<Cluster> getClusters() {
        this.usedByGroupApi = true;
        this.lazyLoad();
        return this.clusters == null ? null : this.clusters.entries;
    }

    public Map<String, String> getExtendedProperties() throws OdpsException {
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("extended", null);
        String resource = ResourceBuilder.buildProjectResource(this.model.name);
        ProjectModel extendedModel = this.client.request(ProjectModel.class, resource, "GET", param);
        return extendedModel.extendedProperties;
    }

    public SecurityManager getSecurityManager() {
        if (this.securityManager == null) {
            this.securityManager = new SecurityManager(this.model.name, this.client);
        }
        return this.securityManager;
    }

    public String getTunnelEndpoint() throws OdpsException {
        String protocol;
        try {
            URI u = new URI(this.client.getEndpoint());
            protocol = u.getScheme();
        }
        catch (URISyntaxException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        String resource = ResourceBuilder.buildProjectResource(this.model.name).concat("/tunnel");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", null);
        Response resp = this.client.request(resource, "GET", params, null, null);
        if (!resp.isOK()) {
            throw new OdpsException("Can't get tunnel server address: " + resp.getStatus());
        }
        String tunnel = new String(resp.getBody());
        return protocol + "://" + tunnel;
    }

    static class PropertyConverter
    implements Converter<LinkedHashMap<String, String>> {
        PropertyConverter() {
        }

        @Override
        public void write(OutputNode outputNode, LinkedHashMap<String, String> properties) throws Exception {
            if (properties != null) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    SimpleXmlUtils.marshal(new Property(name, value), outputNode);
                }
            }
            outputNode.commit();
        }

        @Override
        public LinkedHashMap<String, String> read(InputNode inputNode) throws Exception {
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            Properties props = SimpleXmlUtils.unmarshal(inputNode, Properties.class);
            for (Property entry : props.entries) {
                properties.put(entry.name, entry.value);
            }
            return properties;
        }
    }

    @Root(name="Properties", strict=false)
    static class Properties {
        @ElementList(entry="Property", inline=true, required=false)
        List<Property> entries = new ArrayList<Property>();

        Properties() {
        }
    }

    @Root(name="Property", strict=false)
    static class Property {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Value", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String value;

        Property() {
        }

        Property(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    @Root(name="Clusters", strict=false)
    static class Clusters {
        @ElementList(entry="Cluster", inline=true, required=false)
        List<Cluster> entries = new ArrayList<Cluster>();

        Clusters() {
        }
    }

    @Root(name="Cluster", strict=false)
    public static class Cluster {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="QuotaID", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String quotaID;
        @ElementList(name="Quotas", entry="Quota", required=false)
        List<OptionalQuota> optionalQuotas;

        Cluster() {
        }

        public Cluster(String name, String quotaID) {
            if (StringUtils.isNullOrEmpty((String)name) || StringUtils.isNullOrEmpty((String)quotaID)) {
                throw new IllegalArgumentException("Missing arguments: name, quotaID");
            }
            this.name = name;
            this.quotaID = quotaID;
        }

        public String getName() {
            return this.name;
        }

        public String getQuotaID() {
            return this.quotaID;
        }

        public List<OptionalQuota> getOptionalQuotas() {
            return this.optionalQuotas;
        }

        public void setOptionalQuotas(List<OptionalQuota> optionalQuotas) {
            this.optionalQuotas = optionalQuotas;
        }

        @Root(name="OptionalQuota", strict=false)
        public static class OptionalQuota {
            @Element(name="QuotaID", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String quotaID;
            @Element(name="Properties", required=false)
            @Convert(value=PropertyConverter.class)
            LinkedHashMap<String, String> properties;

            OptionalQuota() {
            }

            public OptionalQuota(String quotaID, Map<String, String> properties) {
                this.quotaID = quotaID;
                this.properties = new LinkedHashMap<String, String>(properties);
            }

            public String getQuotaID() {
                return this.quotaID;
            }

            public Map<String, String> getProperties() {
                return this.properties;
            }
        }
    }

    public static class ExternalProjectProperties {
        private JsonObject rootObj = new JsonObject();
        private JsonObject networkObj = new JsonObject();

        public ExternalProjectProperties(String source) {
            this.rootObj.addProperty("source", source);
            this.rootObj.add("network", (JsonElement)this.networkObj);
        }

        public void addNetworkProperty(String name, String value) {
            this.networkObj.addProperty(name, value);
        }

        public void addProperty(String name, String value) {
            this.rootObj.addProperty(name, value);
        }

        public String toJson() {
            Gson gson = new Gson();
            return gson.toJson((JsonElement)this.rootObj);
        }
    }

    @Root(name="Project", strict=false)
    static class ProjectModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Type", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String type;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date creationTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModified;
        @Element(name="ProjectGroupName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String projectGroupName;
        @Element(name="Properties", required=false)
        @Convert(value=PropertyConverter.class)
        LinkedHashMap<String, String> properties;
        @Element(name="ExtendedProperties", required=false)
        @Convert(value=PropertyConverter.class)
        LinkedHashMap<String, String> extendedProperties;
        @Element(name="State", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String state;
        @Element(name="DefaultCluster", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String defaultCluster;
        @Element(name="Clusters", required=false)
        Clusters clusters;

        ProjectModel() {
        }
    }

    public static enum ProjectType {
        managed,
        external;

    }

    public static enum Status {
        AVAILABLE,
        READONLY,
        DELETING,
        FROZEN,
        UNKOWN;

    }
}

