/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.RestClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ResourceInputStream
extends InputStream {
    private Connection conn;
    private InputStream inputStream;

    ResourceInputStream(RestClient client, String projectName, String resourceName) throws OdpsException {
        String resource = String.format("/projects/%s/resources/%s", projectName, resourceName);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        try {
            this.conn = client.connect(resource, "GET", null, headers);
            Response resp = this.conn.getResponse();
            this.inputStream = this.conn.getInputStream();
            if (!resp.isOK()) {
                String message = new String(IOUtils.readFully(this.inputStream));
                this.conn.disconnect();
                throw new OdpsException(message);
            }
        }
        catch (IOException e) {
            if (this.conn != null) {
                try {
                    this.conn.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new OdpsException(e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputStream.close();
        this.conn.disconnect();
    }
}

