/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.RequestSigner;
import com.aliyun.odps.account.TaobaoRequestSigner;

public class TaobaoAccount
implements Account {
    private String token;
    private String username;
    private String password;
    private String accessId;
    private String accessKey;
    public static final String ALGORITHM_RSA = "rsa";
    public static final String ALGORITHM_HMAC = "hmac-sha1";
    private String algorithm;
    private TaobaoRequestSigner signer;

    public TaobaoAccount(String accessId, String accessKey) {
        this(accessId, accessKey, ALGORITHM_RSA);
    }

    public TaobaoAccount(String accessId, String accessKey, String algorithm) {
        if (accessId == null || accessKey == null || algorithm == null) {
            throw new IllegalArgumentException("Missing arguments: accessId, accessKey, algorithm");
        }
        if (!ALGORITHM_RSA.equals(algorithm) && !ALGORITHM_HMAC.equals(algorithm)) {
            throw new IllegalArgumentException("Unsupported algorithm,only support 'rsa' and 'hmac-sha1'");
        }
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.algorithm = algorithm;
        this.signer = new TaobaoRequestSigner(accessId, accessKey, algorithm);
    }

    public TaobaoAccount(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Missing arguments: token");
        }
        this.token = token;
        this.signer = new TaobaoRequestSigner(this.token);
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public Account.AccountProvider getType() {
        return Account.AccountProvider.TAOBAO;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public RequestSigner getRequestSigner() {
        return this.signer;
    }

    public boolean hasToken() {
        return this.token != null && this.token.trim().length() > 0;
    }

    public String getToken() {
        return this.token;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

