/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.account.RequestSigner;
import com.aliyun.odps.account.SecurityUtils;
import com.aliyun.odps.commons.transport.Request;
import org.apache.commons.codec.binary.Base64;

class TaobaoRequestSigner
implements RequestSigner {
    private String accessId;
    private String accessKey;
    private String algorithm;
    private String token;

    public TaobaoRequestSigner(String accessId, String accessKey, String algorithm) {
        if (accessId == null || accessKey == null || algorithm == null) {
            throw new IllegalArgumentException("Missing arguments: accessId, accessKey, algorithm");
        }
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.algorithm = algorithm;
    }

    public TaobaoRequestSigner(String token) {
        if (token == null || token.trim().length() == 0) {
            throw new IllegalArgumentException("Missing arguments: token");
        }
        this.token = token;
    }

    @Override
    public void sign(String resource, Request req) {
        if (this.token != null && !this.token.trim().isEmpty()) {
            req.getHeaders().put("x-ali-data-service", "ODPS");
            req.getHeaders().put("Authorization", "Bearer " + this.token);
        } else {
            String signature;
            req.getHeaders().put("x-ali-data-auth-signature-type", this.algorithm);
            req.getHeaders().put("x-ali-data-auth-method", "signature");
            if ("rsa".equals(this.algorithm)) {
                SecurityUtils.init();
                try {
                    String strToSign = SecurityUtils.buildCanonicalString(resource, req, "x-ali-data-");
                    signature = Base64.encodeBase64URLSafeString((byte[])SecurityUtils.signature(strToSign.getBytes(), SecurityUtils.getPrivateKey(Base64.decodeBase64((String)this.accessKey))));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if ("hmac-sha1".equals(this.algorithm)) {
                String strToSign = SecurityUtils.buildCanonicalString(resource, req, "x-ali-data-");
                signature = Base64.encodeBase64URLSafeString((byte[])SecurityUtils.hmacsha1Signature(strToSign.getBytes(), this.accessKey.getBytes()));
            } else {
                throw new RuntimeException("Unsupported algorithm,only support 'rsa' and 'hmac-sha1'");
            }
            req.getHeaders().put("Authorization", this.accessId + ":" + signature);
        }
    }
}

