/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.filter;

import com.aliyun.odps.filter.AdvancedFilterCondition;

public class AdvancedFilter {
    private OPERATOR operator = OPERATOR.NULL;
    private AdvancedFilter left;
    private AdvancedFilter right;
    private AdvancedFilterCondition condition;

    protected AdvancedFilter() {
    }

    public AdvancedFilter(AdvancedFilterCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Argument 'condition' cannot be null");
        }
        this.condition = condition;
    }

    public AdvancedFilter getLeft() {
        return this.left;
    }

    public AdvancedFilter getRight() {
        return this.right;
    }

    public OPERATOR getOperator() {
        return this.operator;
    }

    public AdvancedFilterCondition getCondition() {
        return this.condition;
    }

    public void setLeft(AdvancedFilter left) {
        this.left = left;
    }

    public void setRight(AdvancedFilter right) {
        this.right = right;
    }

    public void setOperator(OPERATOR operator) {
        this.operator = operator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.condition != null) {
            sb.append(this.condition.toString());
        } else if (OPERATOR.NOT.equals((Object)this.operator)) {
            sb.append("(NOT ").append(this.left.toString()).append(")");
        } else if (OPERATOR.AND.equals((Object)this.operator)) {
            sb.append("(").append(this.left.toString()).append(" AND ").append(this.right.toString()).append(")");
        } else if (OPERATOR.OR.equals((Object)this.operator)) {
            sb.append("(").append(this.left.toString()).append(" OR ").append(this.right.toString()).append(")");
        } else {
            return "Illegal state";
        }
        return sb.toString();
    }

    public static enum ORDER {
        DESC,
        ASC;

    }

    public static enum PROPERTY {
        TABLE_NAME,
        TABLE_OWNER_ID,
        TABLE_COMMENT,
        TABLE_COL_NAME,
        TABLE_COL_COMMENT,
        PARTITION_NAME,
        PARTITION_LAST_MODIFIED_TIME,
        PARTITION_CREATION_TIME,
        PARTITION_SIZE,
        PARTITION_RECORD_COUNT;

    }

    public static enum PREDICATE {
        EQUALS,
        CONTAINS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        LESS_THAN,
        LESS_THAN_OR_EQUALS;

    }

    public static enum OPERATOR {
        NULL,
        NOT,
        AND,
        OR;

    }
}

