/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.security;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.security.CheckPermissionConstants;
import com.aliyun.odps.security.Role;
import com.aliyun.odps.security.SecurityConfiguration;
import com.aliyun.odps.security.User;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecurityManager {
    private String project;
    private RestClient client;
    private SecurityConfiguration securityConfigration;

    public SecurityManager(String project, RestClient client) {
        this.project = project;
        this.client = client;
        this.securityConfigration = null;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.getSecurityConfiguration(false);
    }

    public SecurityConfiguration getSecurityConfiguration(boolean strip) {
        SecurityConfiguration securityConfiguration;
        if (strip) {
            securityConfiguration = this.securityConfigration == null ? new SecurityConfiguration(this.project, this.client, true) : this.securityConfigration;
        } else {
            if (this.securityConfigration == null) {
                this.securityConfigration = new SecurityConfiguration(this.project, this.client, false);
            }
            securityConfiguration = this.securityConfigration;
        }
        return securityConfiguration;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfigration) throws OdpsException {
        securityConfigration.update(null);
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfigration, String supervisionToken) throws OdpsException {
        securityConfigration.update(supervisionToken);
    }

    public String getProjectPolicy() throws OdpsException {
        String resource = ResourceBuilder.buildProjectResource(this.project);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        Response response = this.client.request(resource, "GET", params, null, null);
        try {
            return new String(response.getBody(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException("Can't parse response!", e);
        }
    }

    public void putProjectPolicy(String policy) throws OdpsException {
        String resource = ResourceBuilder.buildProjectResource(this.project);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        this.client.stringRequest(resource, "PUT", params, null, policy);
    }

    public String getSecurityPolicy() throws OdpsException {
        String resource = ResourceBuilder.buildProjectResource(this.project);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("security_policy", null);
        Response response = this.client.request(resource, "GET", params, null, null);
        try {
            return new String(response.getBody(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException("Can't parse response!", e);
        }
    }

    public void putSecurityPolicy(String securityPolicy) throws OdpsException {
        String resource = ResourceBuilder.buildProjectResource(this.project);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("security_policy", null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        this.client.stringRequest(resource, "PUT", params, headers, securityPolicy);
    }

    public String getRolePolicy(String roleName) throws OdpsException {
        String resource = ResourceBuilder.buildRoleResource(this.project, roleName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        Response response = this.client.request(resource, "GET", params, null, null);
        try {
            return new String(response.getBody(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException("Can't parse response!", e);
        }
    }

    public void putRolePolicy(String roleName, String policy) throws OdpsException {
        String resource = ResourceBuilder.buildRoleResource(this.project, roleName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        this.client.stringRequest(resource, "PUT", params, null, policy);
    }

    public List<User> listUsers() throws OdpsException {
        String resource = ResourceBuilder.buildUsersResource(this.project);
        ListUsersResponse resp = this.client.request(ListUsersResponse.class, resource, "GET");
        ArrayList<User> users = new ArrayList<User>();
        for (User.UserModel model : resp.users) {
            User t = new User(model, this.project, this.client);
            users.add(t);
        }
        return users;
    }

    public List<Role> listRoles() throws OdpsException {
        String resource = ResourceBuilder.buildRolesResource(this.project);
        ListRolesResponse resp = this.client.request(ListRolesResponse.class, resource, "GET");
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Role.RoleModel model : resp.roles) {
            Role t = new Role(model, this.project, this.client);
            roles.add(t);
        }
        return roles;
    }

    @Deprecated
    public List<Role> listRolesForUser(String uid) throws OdpsException {
        return this.listRolesForUserID(uid);
    }

    public List<Role> listRolesForUserID(String uid) throws OdpsException {
        return this.listRolesForUserInternal(uid, null);
    }

    public List<Role> listRolesForUserName(String userName) throws OdpsException {
        return this.listRolesForUserInternal(userName, "displayname");
    }

    private List<Role> listRolesForUserInternal(String user, String type) throws OdpsException {
        String resource = ResourceBuilder.buildUserResource(this.project, user);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roles", null);
        if (!StringUtils.isNullOrEmpty((String)type)) {
            params.put("type", type);
        }
        ListRolesResponse resp = this.client.request(ListRolesResponse.class, resource, "GET", params, null, null);
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Role.RoleModel model : resp.roles) {
            Role t = new Role(model, this.project, this.client);
            roles.add(t);
        }
        return roles;
    }

    public List<User> listUsersForRole(String roleName) throws OdpsException {
        String resource = ResourceBuilder.buildRoleResource(this.project, roleName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("users", null);
        ListUsersResponse resp = this.client.request(ListUsersResponse.class, resource, "GET", params, null, null);
        ArrayList<User> users = new ArrayList<User>();
        for (User.UserModel model : resp.users) {
            User t = new User(model, this.project, this.client);
            users.add(t);
        }
        return users;
    }

    public CheckPermissionResultInfo checkPermission(PermissionDesc desc) throws OdpsException {
        String resource = "/projects/" + ResourceBuilder.encodeObjectName(desc.projectName) + "/auth/";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        CheckPermissionResponse response = this.client.stringRequest(CheckPermissionResponse.class, resource, "POST", null, headers, desc.toJson());
        CheckPermissionConstants.CheckPermissionResult result = CheckPermissionConstants.CheckPermissionResult.valueOf(response.result);
        return new CheckPermissionResultInfo(result, response.message);
    }

    @Deprecated
    public CheckPermissionConstants.CheckPermissionResult checkPermission(CheckPermissionConstants.ObjectType type, String objectName, CheckPermissionConstants.ActionType action, String projectName, List<String> columns) throws OdpsException {
        String resource;
        CheckPermissionResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type.toString());
        params.put("name", objectName);
        params.put("grantee", action.toString());
        if (columns != null && !columns.isEmpty()) {
            params.put("columns", StringUtils.join((Object[])columns.toArray(), (String)","));
        }
        return (response = this.client.request(CheckPermissionResponse.class, resource = "/projects/" + ResourceBuilder.encodeObjectName(projectName) + "/auth/", "GET", params, null, null)).getResult().toUpperCase().equals("ALLOW") ? CheckPermissionConstants.CheckPermissionResult.Allow : CheckPermissionConstants.CheckPermissionResult.Deny;
    }

    @Deprecated
    public CheckPermissionConstants.CheckPermissionResult checkPermission(CheckPermissionConstants.ObjectType type, String objectName, CheckPermissionConstants.ActionType action, List<String> columns) throws OdpsException {
        return this.checkPermission(type, objectName, action, this.project, columns);
    }

    @Deprecated
    public CheckPermissionConstants.CheckPermissionResult checkPermission(CheckPermissionConstants.ObjectType type, String objectName, CheckPermissionConstants.ActionType action) throws OdpsException {
        return this.checkPermission(type, objectName, action, this.project);
    }

    @Deprecated
    public CheckPermissionConstants.CheckPermissionResult checkPermission(CheckPermissionConstants.ObjectType type, String objectName, CheckPermissionConstants.ActionType action, String projectName) throws OdpsException {
        return this.checkPermission(type, objectName, action, projectName, null);
    }

    public AuthorizationQueryInstance run(String query, Boolean jsonOutput) throws OdpsException {
        return this.run(query, jsonOutput, null);
    }

    public AuthorizationQueryInstance run(String query, Boolean jsonOutput, String supervisionToken) throws OdpsException {
        String xmlRequest;
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(ResourceBuilder.encodeObjectName(this.project)).append("/authorization");
        AuthorizationQueryRequest request = new AuthorizationQueryRequest(query, jsonOutput);
        try {
            xmlRequest = SimpleXmlUtils.marshal(request);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (supervisionToken != null) {
            headers.put("odps-x-supervision-token", supervisionToken);
        }
        headers.put("Content-Type", "application/xml");
        Response response = this.client.stringRequest(resource.toString(), "POST", null, headers, xmlRequest);
        try {
            AuthorizationQueryResponse queryResponse = SimpleXmlUtils.unmarshal(response, AuthorizationQueryResponse.class);
            if (response.getStatus() == 200) {
                return new AuthorizationQueryInstance(queryResponse.getResult());
            }
            return new AuthorizationQueryInstance(this.project, queryResponse.getResult(), this);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public String runQuery(String query, Boolean jsonOutput) throws OdpsException {
        return this.runQuery(query, jsonOutput, null);
    }

    public String runQuery(String query, Boolean jsonOutput, String supervisionToken) throws OdpsException {
        return this.run(query, jsonOutput, supervisionToken).waitForSuccess();
    }

    public String generateAuthorizationToken(String policy, String type) throws OdpsException {
        if (type.equalsIgnoreCase("Bearer")) {
            StringBuilder resource = new StringBuilder();
            resource.append("/projects/").append(ResourceBuilder.encodeObjectName(this.project)).append("/authorization");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sign_bearer_token", null);
            AuthorizationQueryResponse response = this.client.stringRequest(AuthorizationQueryResponse.class, resource.toString(), "POST", params, headers, policy);
            return response.getResult();
        }
        throw new OdpsException("Unsupport token type" + type);
    }

    public static class PermissionDesc {
        private String projectName;
        private CheckPermissionConstants.ObjectType objectType;
        private String objectName;
        private CheckPermissionConstants.ActionType actionType;
        private Map<String, String> params;

        public PermissionDesc(String projectName, CheckPermissionConstants.ObjectType objectType, String objectName, CheckPermissionConstants.ActionType actionType) {
            this.projectName = Objects.requireNonNull(projectName);
            this.objectType = Objects.requireNonNull(objectType);
            this.objectName = Objects.requireNonNull(objectName);
            this.actionType = Objects.requireNonNull(actionType);
            this.params = new HashMap<String, String>();
        }

        public String getProjectName() {
            return this.projectName;
        }

        public CheckPermissionConstants.ObjectType getObjectType() {
            return this.objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public CheckPermissionConstants.ActionType getActionType() {
            return this.actionType;
        }

        public Map<String, String> getParams() {
            return new HashMap<String, String>(this.params);
        }

        public void setPrincipal(String principal) {
            this.params.put("Principal", principal);
        }

        public void setColumns(List<String> columns) {
            this.params.put("odps:SelectColumns", GsonObjectBuilder.get().toJson(columns));
        }

        public void addParam(String key, String value) {
            this.params.put(key, value);
        }

        private String buildResourceString(CheckPermissionConstants.ObjectType objectType, String objectName) {
            switch (objectType) {
                case Project: {
                    return ResourceBuilder.buildProjectResource(this.projectName);
                }
                case Table: {
                    return ResourceBuilder.buildTableResource(this.projectName, objectName);
                }
                case Function: {
                    return ResourceBuilder.buildFunctionResource(this.projectName, objectName);
                }
                case Instance: {
                    return ResourceBuilder.buildInstanceResource(this.projectName, objectName);
                }
                case Resource: {
                    return ResourceBuilder.buildResourceResource(this.projectName, objectName);
                }
            }
            throw new IllegalArgumentException("Unsupported object type");
        }

        public String toJson() {
            JsonArray jsonArray = new JsonArray();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Action", this.actionType.name());
            jsonObject.addProperty("Resource", this.buildResourceString(this.objectType, this.objectName));
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                jsonObject.addProperty(param.getKey(), param.getValue());
            }
            jsonArray.add((JsonElement)jsonObject);
            return GsonObjectBuilder.get().toJson((JsonElement)jsonArray);
        }
    }

    public static class CheckPermissionResultInfo {
        public CheckPermissionConstants.CheckPermissionResult result;
        public String message;

        public CheckPermissionResultInfo(CheckPermissionConstants.CheckPermissionResult result, String message) {
            this.result = Objects.requireNonNull(result);
            this.message = message;
        }

        public CheckPermissionConstants.CheckPermissionResult getResult() {
            return this.result;
        }

        public String getMessage() {
            return this.message;
        }
    }

    @Root(name="Auth", strict=false)
    private static class CheckPermissionResponse {
        @Element(name="Result", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String result;
        @Element(name="Message", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String message;

        private CheckPermissionResponse() {
        }

        public String getResult() {
            return this.result;
        }

        public String getMessage() {
            return this.message;
        }
    }

    @Root(name="Roles", strict=false)
    private static class ListRolesResponse {
        @ElementList(entry="Role", inline=true, required=false)
        private List<Role.RoleModel> roles = new ArrayList<Role.RoleModel>();

        private ListRolesResponse() {
        }
    }

    @Root(name="Users", strict=false)
    private static class ListUsersResponse {
        @ElementList(entry="User", inline=true, required=false)
        private List<User.UserModel> users = new ArrayList<User.UserModel>();

        private ListUsersResponse() {
        }
    }

    public class AuthorizationQueryInstance {
        private String queryResult;
        private String instanceId;
        private String projectName;
        private SecurityManager securityManager;
        private boolean isSync;

        public AuthorizationQueryInstance(String result) {
            this.queryResult = result;
            this.isSync = true;
        }

        public AuthorizationQueryInstance(String projectName, String instanceId, SecurityManager sm) {
            if (StringUtils.isNullOrEmpty((String)projectName) || StringUtils.isNullOrEmpty((String)instanceId)) {
                throw new IllegalArgumentException("Arguments: project and instance id cannot be null or empty.");
            }
            this.projectName = projectName;
            this.instanceId = instanceId;
            this.securityManager = sm;
            this.isSync = false;
        }

        public String getId() {
            if (this.isSync) {
                return null;
            }
            return this.instanceId;
        }

        public boolean isSync() {
            return this.isSync;
        }

        public String waitForSuccess() throws OdpsException {
            return this.waitForSuccess(1000L);
        }

        public String waitForSuccess(long interval) throws OdpsException {
            if (this.isSync) {
                return this.queryResult;
            }
            while (!this.isTerminated()) {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    throw new OdpsException(e);
                }
            }
            AuthorizationQueryStatusModel model = this.getModel();
            if (model.getStatus() == AuthorizationQueryStatus.TERMINATED) {
                return model.getResult();
            }
            throw new OdpsException("Authorization query failed: " + model.getResult());
        }

        private AuthorizationQueryStatusModel getModel() throws OdpsException {
            StringBuilder resource = new StringBuilder();
            resource.append("/projects/").append(ResourceBuilder.encodeObjectName(SecurityManager.this.project)).append("/authorization/").append(this.instanceId);
            return this.securityManager.client.request(AuthorizationQueryStatusModel.class, resource.toString(), "GET", null, null, null);
        }

        public boolean isTerminated() throws OdpsException {
            return this.getStatus() != AuthorizationQueryStatus.RUNNING;
        }

        public AuthorizationQueryStatus getStatus() throws OdpsException {
            if (!this.isSync) {
                return this.getModel().getStatus();
            }
            return AuthorizationQueryStatus.TERMINATED;
        }

        public String getResult() throws OdpsException {
            if (!this.isSync) {
                this.queryResult = this.getModel().getResult();
            }
            return this.queryResult;
        }
    }

    @Root(name="AuthorizationQuery", strict=false)
    private static class AuthorizationQueryStatusModel {
        @Element(name="Result", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String result;
        @Element(name="Status", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String status;

        private AuthorizationQueryStatusModel() {
        }

        public String getResult() {
            return this.result;
        }

        public AuthorizationQueryStatus getStatus() throws OdpsException {
            if (StringUtils.isNullOrEmpty((String)this.status)) {
                throw new IllegalArgumentException("Cannot get authorization query status.");
            }
            try {
                return AuthorizationQueryStatus.valueOf(this.status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new OdpsException("Unknown authorization query status: " + this.status);
            }
        }
    }

    public static enum AuthorizationQueryStatus {
        TERMINATED,
        RUNNING,
        FAILED;

    }

    @Root(name="Authorization", strict=false)
    private static class AuthorizationQueryResponse {
        @Element(name="Result", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String result;

        private AuthorizationQueryResponse() {
        }

        public String getResult() {
            return this.result;
        }
    }

    @Root(name="Authorization", strict=false)
    private static class AuthorizationQueryRequest {
        @Element(name="Query", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String query;
        @Element(name="ResponseInJsonFormat", required=false)
        private boolean responseInJsonFormat;

        public AuthorizationQueryRequest() {
            this.query = "";
            this.responseInJsonFormat = true;
        }

        public AuthorizationQueryRequest(String query, boolean jsonFormat) {
            this.query = query;
            this.responseInJsonFormat = jsonFormat;
        }
    }
}

