/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Survey;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.task.SQLTask;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@Root(name="PMC", strict=false)
public class PMCTask
extends SQLTask {
    private static final String ANONYMOUS_PMC_TASK_NAME = "AnonymousPMCTask";
    @ElementList(name="TimeStamps", entry="TimeStamp", required=false)
    private List<String> timeStamps;
    private static Map<String, String> defaultHints;

    public List<String> getTimeStamps() {
        return this.timeStamps;
    }

    public static void setDefaultHints(Map<String, String> hints) {
        defaultHints = hints;
    }

    public static void removeDefaultHints() {
        defaultHints = null;
    }

    public static List<Record> getResult(Instance instance) throws OdpsException {
        return PMCTask.getResult(instance, ANONYMOUS_PMC_TASK_NAME);
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance) throws OdpsException, IOException {
        return PMCTask.getResultByInstanceTunnel(instance, ANONYMOUS_PMC_TASK_NAME);
    }

    public static ResultSet getResultSet(Instance instance) throws OdpsException, IOException {
        return PMCTask.getResultSet(instance, ANONYMOUS_PMC_TASK_NAME);
    }

    public static ResultSet getResultSet(Instance instance, Long limit) throws OdpsException, IOException {
        return PMCTask.getResultSet(instance, ANONYMOUS_PMC_TASK_NAME, limit);
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance, Long limit) throws OdpsException, IOException {
        return PMCTask.getResultByInstanceTunnel(instance, ANONYMOUS_PMC_TASK_NAME, limit);
    }

    public static List<String> getSqlWarning(Instance instance) throws OdpsException {
        return PMCTask.getSqlWarning(instance, ANONYMOUS_PMC_TASK_NAME);
    }

    public static Instance run(Odps odps, String sql) throws OdpsException {
        String project = odps.getDefaultProject();
        if (project == null) {
            throw new OdpsException("default project required.");
        }
        return PMCTask.run(odps, project, sql, ANONYMOUS_PMC_TASK_NAME, null, null, "pmc");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return PMCTask.run(odps, project, sql, taskName, hints, aliases, "pmc");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, int priority) throws OdpsException {
        return PMCTask.run(odps, project, sql, taskName, hints, aliases, priority, "pmc");
    }

    public static Instance run(Odps odps, String project, String sql, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return PMCTask.run(odps, project, sql, ANONYMOUS_PMC_TASK_NAME, hints, aliases, "pmc");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, Integer priority, String type) throws OdpsException {
        String json;
        PMCTask task = new PMCTask();
        task.setQuery(sql);
        task.setName(taskName);
        task.setProperty("type", type);
        if (hints == null) {
            hints = defaultHints;
        }
        if (hints != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (aliases != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (priority != null) {
            return odps.instances().create(project, task, priority);
        }
        return odps.instances().create(project, task);
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, String type) throws OdpsException {
        return PMCTask.run(odps, project, sql, taskName, hints, aliases, null, type);
    }
}

