# 将 Logstash 收集的日志导入到 ODPS

通过使用 Logstash 插件 [logstash-output-odpstunnel](http://gitlab.alibaba-inc.com/huatian.zht/logstash-output-odpstunnel)，可以将 Logstash 收集的日志使用 ODPS Tunnel 上传功能上传到 ODPS。

本文将以搭建一个简单的测试实例为例，说明如何构建、安装插件 logstash-output-odpstunnel，以及对应的 Logstash 配置。

## 0. 准备工作

1. 拥有一个测试用的 ODPS 账号，该账号具有在某个 Project 下创建表的能力（用于存放上传的示例数据）。
2. [ODPS 客户端](http://help.aliyun-inc.com/internaldoc/detail/27971.html)
3. 一个已经安装 JRuby 和 Logstash 的机器，作为日志的产生和收集端。

## 1. 下载&构建插件

### 使用预装插件的 logstash 实例

本仓库中含有一个已预装此插件的 logstash 7.8.0 实例。 文件名为 `logstash-7.8.0-tunneled-release.tar.gz`. 若使用此实例，可跳过步骤 (1) (2) 。

### 下载插件

``` shell
git clone git@gitlab.alibaba-inc.com:huatian.zht/logstash-output-odpstunnel.git
```

注：插件内含了一个版本的 ODPS Java SDK。随着时间经过，这个 SDK 可能过时。建议从 [Maven Repository](mvnrepo.alibaba-inc.com) 搜索下载最新版本的 `odps-sdk-core` 和 `odps-sdk-commons` 及对应的所有依赖 jar 并将 `logstash-output-odpstunnel/vendor/jar-dependencies/runtime-jars/` 下的所有包替换。另外，可以手动构建 ODPS Java SDK，然后直接利用 `logstash-output-odpstunnel/autovendor.sh` 脚本自动导入所有所需的 jar 包。具体使用方法请阅读该脚本的注释。

### 构建插件

源码目录下执行

```shell
jruby -S gem install bundler # 安装 bundler
jruby -S bundle install # 安装 ruby 依赖
jruby -S gem build logstash-output-odpstunnel.gemspec # 构建插件
```

## 2. 安装插件

``` shell
/path/to/your/logstash/bin/logstash-plugin install /path/to/your/logstash-output-tunnel-plugin/logstash-output-odpstunnel-1.0.0.gem
```

测试是否安装成功：

```shell
/path/to/your/logstash/bin/logstash-plugin list | grep odpstunnel
```

## 3. 创建测试表

``` sql
create table logstash_test_fullset (content1 datetime, content2 bigint, content3 boolean, content4 double) partitioned by (pt string);
```

使用的测试 log 数据如下：

```text
t=2020-02-08T12:34:56 bi=123334 bl=true blf=45.323
t=2020-02-09T12:34:56 bi=355645 bl=false blf=44.233
t=2020-02-10T12:34:56 bi=798798 bl=randomval blf=46.334
```



## 4. 编写 Logstash 配置文件

```ruby
input { stdin {} }

filter { kv {} }

output {
        odpstunnel {
                aliyun_access_id => "<YOUR_ACCESS_ID>"
                aliyun_access_key => "<YOUR_ACCESS_KEY>"
                aliyun_odps_endpoint => "<YOUR_ODPS_ENDPOINT>"
                project => "<YOUR_PROJECT>"
                table => "logstash_test_fullset"
                partition => "pt=$<t.strftime('%Y')>"
                partition_time_format => "%Y-%m-%dT%H:%M:%S"
                value_fields => ["t", "bi", "bl", "blf"]
        }
}
```

其中：

- `alien_access_id` `aliyun_access_key` `aliyun_odps_endpoint` 和 `project` 需要填入对应的实际值。
- `table` 即需要导入数据的表。在本例中，为刚刚创建的 `logstash_test_fullset`
- `partition` 告诉插件该如何根据 log 字段生成对应的分区信息。如果目标表有多个分区，需要指定到最后一级。配置格式如下：
  - 如果某个分区的值为常量，则使用 `partition_name=some_constant`
  - 如果某个分区的值为 log 中一个字段的值，则使用 `partition_name=$<field_name>` 来引用
  - 如果某个分区的值为 log 中一个日期时间字段的值，并且需要进行重新格式化，则使用 `partition_name=$<field_name.strftime('{time_format}')>` 来引用。其中 `time_format` 是重新格式化的[格式化字符串](https://man7.org/linux/man-pages/man3/strftime.3.html)。
  - 多个分区之间用英文逗号连接，分区指定的顺序和建表时顺序必须一致。
  - 在本例中，将格式化到仅保留年份（`%Y`）。
- `partition_time_format` 指定当一个日期时间字段被分区信息引用时，该字段的[源格式字符串](https://man7.org/linux/man-pages/man3/strptime.3.html)。
  - 在本例中，时间字段 `t` 的数据为 `2020-02-08T12:34:56`，对应格式字符串 `%Y-%m-%dT%H:%M:%S`。
- `value_fields` 指定表中的每个字段对应的 log 字段，指定顺序与表中字段的顺序一致。
  - 在本例中，表字段的顺序为 `(content1 datetime, content2 bigint, content3 boolean, content4 double)`，依次对应 `"t", "bi", "bl", "blf"`

保存为 `pipeline.conf` 。

## 5. 运行&测试

```shell
/path/to/your/logstash/bin/logstash -f /path/to/your/pipeline.conf
```

出现 `Successfully started Logstash API endpoint` 时， Logstash 启动完毕。

在命令行中输入3.中的测试数据，等待直到提示 `write .. records on partition .. completed` ，写 ODPS 成功。

在 ODPS 客户端中查询写入的数据：

```sql
odps@ your_project>select * from logstash_test_fullset;

....
Summary:

+------------+------------+----------+------------+------------+
| content1   | content2   | content3 | content4   | pt         |
+------------+------------+----------+------------+------------+
| 2020-02-10 12:34:56 | 798798     | false    | 46.334     | 2020       |
| 2020-02-08 12:34:56 | 123334     | true     | 45.323     | 2020       |
| 2020-02-09 12:34:56 | 355645     | false    | 44.233     | 2020       |
+------------+------------+----------+------------+------------+
3 records (at most 10000 supported) fetched by instance tunnel.
```



## 附录：支持的数据类型

此插件支持以下的 ODPS 数据类型：

- String
- BigInt
- Double
- DateTime
	- log 中该类型的字段的格式将自动使用 ruby `Time.parse` 函数推断。
- Boolean
	- 如果 log 中该字段 `.to_string().lowercase() == "true"` 则结果为 true 。其他任何值为 false 。

## 附录：Changelog

1.1.0: support upload using streaming tunnel, to achieve better performance.

1.0.0: initial release